(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87564,       1822]
NotebookOptionsPosition[     84350,       1712]
NotebookOutlinePosition[     84961,       1734]
CellTagsIndexPosition[     84918,       1731]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , cylindrical diffusion",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9, {3.570553977298891*^9, 3.570553984193285*^9}, {
   3.570796493918581*^9, 3.570796494859635*^9}, {3.570806877226472*^9, 
   3.570806895420513*^9}, {3.5708146785726833`*^9, 3.5708146831169434`*^9}, {
   3.570815424029321*^9, 3.570815424509349*^9}, {3.5708164195502615`*^9, 
   3.5708164228124485`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cdl\"\>", ",", "\<\"Co\"\>", ",", "\<\"Dox\"\>", 
   ",", "\<\"F\"\>", ",", "\<\"lom\"\>", ",", "\<\"lZM\"\>", ",", "\<\"R\"\>",
    ",", "\<\"r0\"\>", ",", "\<\"Rct\"\>", ",", "\<\"res\"\>", 
   ",", "\<\"Rs\"\>", ",", "\<\"T\"\>", ",", "\<\"Z\"\>", ",", "\<\"z0\"\>", 
   ",", "\<\"Z1\"\>", ",", "\<\"Z2\"\>", ",", "\<\"Zf\"\>", ",", "\<\"ZM\"\>",
    ",", "\<\"Zw\"\>", ",", "\<\"\[Sigma]\"\>", ",", "\<\"\[CurlyPhi]\"\>", 
   ",", "\<\"\[Omega]\"\>", ",", "\<\"\[AliasDelimiter]\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9, 
   3.57053934340388*^9, 3.570555127082655*^9, 3.5705553201646986`*^9, 
   3.5705555073474045`*^9, 3.5705555648816957`*^9, 3.5705571982221174`*^9, 
   3.570557235474248*^9, 3.5705572710812845`*^9, 3.570557954506374*^9, {
   3.5705580936843348`*^9, 3.57055813259256*^9}, 3.5707965547220583`*^9, 
   3.5708073488754487`*^9, 3.570807449685215*^9, {3.5708147142597246`*^9, 
   3.5708147320947447`*^9}, 3.570814824127009*^9, 3.570815683025135*^9, 
   3.570815891795076*^9, 3.5708160949756975`*^9, 3.57081624311417*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{"R", "*", 
   RowBox[{"T", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["F", "2"], "*", "Co", "*", 
      RowBox[{"Sqrt", "[", "Dox", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}, {3.5705383096987553`*^9, 3.570538399684902*^9}, {
   3.570538455217078*^9, 3.5705385242120247`*^9}, {3.5705385781811113`*^9, 
   3.5705386130431056`*^9}, {3.5705386973959303`*^9, 
   3.5705388328526783`*^9}, {3.5705388686457253`*^9, 
   3.5705388937151594`*^9}, {3.5705539935738215`*^9, 
   3.5705540484529605`*^9}, {3.570814719280012*^9, 3.5708147288465595`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5705388964243145`*^9, 3.5705393435168867`*^9, 3.5705540511101127`*^9, 
   3.570555127196661*^9, 3.5705553203117065`*^9, 3.570555514380807*^9, 
   3.5705555650777063`*^9, 3.5705571983761263`*^9, 3.570557235591254*^9, 
   3.5705572711862907`*^9, 3.5705579546343813`*^9, {3.5705580938113422`*^9, 
   3.5705581327385683`*^9}, 3.5707965657976923`*^9, 3.5708073489944553`*^9, 
   3.570807449798221*^9, 3.5708147354439363`*^9, 3.5708148242310147`*^9, 
   3.570815687570395*^9, 3.570815895395282*^9, 3.5708160951057043`*^9, 
   3.570816243231177*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zw", "=", 
  RowBox[{
   RowBox[{"\[Sigma]", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}]}], "*", 
   RowBox[{
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", "z0"}], "]"}], "/", 
    RowBox[{"BesselK", "[", 
     RowBox[{"1", ",", "z0"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5705392072310915`*^9, 3.5705392132664366`*^9}, {
  3.5705540591705737`*^9, 3.5705543167563066`*^9}, {3.570555519555103*^9, 
  3.570555522548274*^9}, {3.570796514971785*^9, 3.570796546575593*^9}, {
  3.5708069943391705`*^9, 3.5708070958879786`*^9}, {3.5708071281578245`*^9, 
  3.5708071292618876`*^9}, {3.570814709664462*^9, 3.5708147240482845`*^9}, {
  3.5708158205910034`*^9, 3.5708158592162123`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T", " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "z0"}], "]"}]}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"], " ", 
   SqrtBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"1", ",", "z0"}], "]"}]}]]], "Output",
 CellChangeTimes->{3.570815861874365*^9, 3.570815908316021*^9, 
  3.5708160951347065`*^9, 3.570816243268179*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z0", "=", 
  RowBox[{"r0", "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"\[ImaginaryI]", "*", 
     RowBox[{"\[Omega]", "/", "Dox"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"r0", " ", 
  SqrtBox[
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]], "Output",
 CellChangeTimes->{3.5708159204997177`*^9, 3.570816095161708*^9, 
  3.570816243304181*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zf", "=", 
  RowBox[{"Rct", "+", "Zw"}]}]], "Input",
 CellChangeTimes->{{3.5705543548144836`*^9, 3.5705543616518745`*^9}}],

Cell[BoxData[
 RowBox[{"Rct", "+", 
  FractionBox[
   RowBox[{"R", " ", "T", " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", 
      RowBox[{"r0", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], "]"}]}], 
   RowBox[{"Co", " ", 
    SqrtBox["Dox"], " ", 
    SuperscriptBox["F", "2"], " ", 
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"1", ",", 
      RowBox[{"r0", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
     "]"}]}]]}]], "Output",
 CellChangeTimes->{
  3.570554363002952*^9, 3.5705551272456636`*^9, 3.5705553204257135`*^9, 
   3.57055552685052*^9, 3.5705555651917133`*^9, 3.5705571984721317`*^9, 
   3.5705572356532583`*^9, 3.570557271260295*^9, 3.570557954715386*^9, {
   3.5705580938923464`*^9, 3.570558132861575*^9}, 3.570796595635399*^9, 
   3.5708071463708663`*^9, 3.57080734907146*^9, 3.5708074498762255`*^9, 
   3.5708147709599676`*^9, 3.570814824286018*^9, 3.5708159265820656`*^9, 
   3.570816095218711*^9, 3.5708162433441834`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "Zf"}], "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.570554375573671*^9, 3.5705544213962917`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"R", " ", "T", " ", 
        RowBox[{"BesselK", "[", 
         RowBox[{"0", ",", 
          RowBox[{"r0", " ", 
           SqrtBox[
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], "]"}]}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
        RowBox[{"BesselK", "[", 
         RowBox[{"1", ",", 
          RowBox[{"r0", " ", 
           SqrtBox[
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
         "]"}]}]]}]]}]]}]], "Output",
 CellChangeTimes->{3.570796818595151*^9, 3.5708071546633406`*^9, 
  3.570807349107462*^9, 3.5708074499162283`*^9, 3.5708147773023305`*^9, 
  3.5708148243250203`*^9, 3.570815948807337*^9, 3.5708160952457128`*^9, 
  3.570816243388186*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5705544366851664`*^9, 3.570554446386721*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T", " ", 
         RowBox[{"BesselK", "[", 
          RowBox[{"0", ",", 
           RowBox[{"r0", " ", 
            SqrtBox[
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
          "]"}]}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
         RowBox[{"BesselK", "[", 
          RowBox[{"1", ",", 
           RowBox[{"r0", " ", 
            SqrtBox[
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
          "]"}]}]]}]]}]]}], "]"}]], "Output",
 CellChangeTimes->{
  3.570554447671795*^9, 3.5705551273266687`*^9, 3.57055532054072*^9, 
   3.5705555653087196`*^9, 3.5705568274239087`*^9, 3.5705571985761375`*^9, 
   3.570557235721262*^9, 3.570557271341299*^9, 3.5705579548053913`*^9, {
   3.5705580939923525`*^9, 3.570558132978582*^9}, 3.5707968342810483`*^9, 
   3.5708071803678107`*^9, 3.570807349181466*^9, 3.5708074500122337`*^9, 
   3.5708148243530216`*^9, 3.57081596599432*^9, 3.5708160952997155`*^9, 
   3.570816243437189*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.570554449777915*^9, 3.5705544568673205`*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T", " ", 
         RowBox[{"BesselK", "[", 
          RowBox[{"0", ",", 
           RowBox[{"r0", " ", 
            SqrtBox[
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
          "]"}]}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
         RowBox[{"BesselK", "[", 
          RowBox[{"1", ",", 
           RowBox[{"r0", " ", 
            SqrtBox[
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
          "]"}]}]]}]]}]]}], "]"}]], "Output",
 CellChangeTimes->{
  3.5705544587714295`*^9, 3.570555127376672*^9, 3.5705553206007233`*^9, 
   3.570555565362723*^9, 3.5705568312251263`*^9, 3.5705571986381407`*^9, 
   3.570557235754264*^9, 3.5705572713763013`*^9, 3.5705579548483934`*^9, {
   3.5705580940273542`*^9, 3.5705581330375853`*^9}, 3.5707968400143766`*^9, 
   3.570807186182143*^9, 3.570807349222469*^9, 3.570807450058236*^9, 
   3.570814824378023*^9, 3.5708159693215103`*^9, 3.5708160953307176`*^9, 
   3.570816243477191*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5705544727082267`*^9, 3.5705544926593676`*^9}, {
  3.570554806084295*^9, 3.5705548115736084`*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T", " ", 
            RowBox[{"BesselK", "[", 
             RowBox[{"0", ",", 
              RowBox[{"r0", " ", 
               SqrtBox[
                FractionBox[
                 RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
             "]"}]}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
            RowBox[{"BesselK", "[", 
             RowBox[{"1", ",", 
              RowBox[{"r0", " ", 
               SqrtBox[
                FractionBox[
                 RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
             "]"}]}]]}]]}]]}], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Re", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T", " ", 
            RowBox[{"BesselK", "[", 
             RowBox[{"0", ",", 
              RowBox[{"r0", " ", 
               SqrtBox[
                FractionBox[
                 RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
             "]"}]}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
            RowBox[{"BesselK", "[", 
             RowBox[{"1", ",", 
              RowBox[{"r0", " ", 
               SqrtBox[
                FractionBox[
                 RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
             "]"}]}]]}]]}]]}], "]"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9, 
   3.570807190127369*^9, 3.570807349278472*^9, 3.5708074501202397`*^9, 
   3.570814824428026*^9, 3.570815977285966*^9, 3.5708160953817205`*^9, 
   3.570816243528194*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T", " ", 
              RowBox[{"BesselK", "[", 
               RowBox[{"0", ",", 
                RowBox[{"r0", " ", 
                 SqrtBox[
                  FractionBox[
                   RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
               "]"}]}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
              RowBox[{"BesselK", "[", 
               RowBox[{"1", ",", 
                RowBox[{"r0", " ", 
                 SqrtBox[
                  FractionBox[
                   RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
               "]"}]}]]}]]}]]}], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Re", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T", " ", 
              RowBox[{"BesselK", "[", 
               RowBox[{"0", ",", 
                RowBox[{"r0", " ", 
                 SqrtBox[
                  FractionBox[
                   RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
               "]"}]}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
              RowBox[{"BesselK", "[", 
               RowBox[{"1", ",", 
                RowBox[{"r0", " ", 
                 SqrtBox[
                  FractionBox[
                   RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}]}], 
               "]"}]}]]}]]}]]}], "]"}], "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9, 
   3.570807190127369*^9, 3.570807349278472*^9, 3.5708074501202397`*^9, 
   3.570814824428026*^9, 3.570815977285966*^9, 3.5708160953817205`*^9, 
   3.5708162435331945`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.5705545122914906`*^9, 3.5705545204389567`*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{
  3.570554521526019*^9, 3.570555127457676*^9, 3.5705553207367315`*^9, 
   3.570555565496731*^9, 3.570557198785149*^9, 3.570557235825268*^9, 
   3.5705572714463053`*^9, 3.570557954939399*^9, {3.5705580941353607`*^9, 
   3.570558133168593*^9}, 3.570796845715702*^9, 3.570807199134884*^9, 
   3.5708073493374753`*^9, 3.5708074501822433`*^9, 3.570814824458028*^9, 
   3.5708159809821773`*^9, 3.5708160954197226`*^9, 3.5708162436442003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"20", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Dox", "=", 
  RowBox[{"1", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Co", "=", 
  RowBox[{"2", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"r0", "=", "0.01"}], "\[IndentingNewLine]", 
 RowBox[{"F", "=", "96485"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "298.15"}], "\[IndentingNewLine]", 
 RowBox[{"R", "=", "8.31447"}]}], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
   3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
   3.570533164322457*^9}, {3.5705389117301893`*^9, 3.570538957625815*^9}, {
   3.5705545315715933`*^9, 3.5705545321316257`*^9}, {3.5705546440840287`*^9, 
   3.570554744162753*^9}, {3.570555291317048*^9, 3.5705552918600793`*^9}, {
   3.570558088948064*^9, 3.57055814814845*^9}, 3.5707968842859087`*^9, {
   3.570807239695204*^9, 3.57080727179004*^9}, {3.570816005567583*^9, 
   3.57081600673365*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.570816243740206*^9}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.5708162437452064`*^9}],

Cell[BoxData[
 FractionBox["1", "50000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.570816243748206*^9}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.570816243755207*^9}],

Cell[BoxData[
 FractionBox["1", "500000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.570816243760207*^9}],

Cell[BoxData["0.01`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.5708162437652073`*^9}],

Cell[BoxData["96485"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.570816243769208*^9}],

Cell[BoxData["298.15`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.5708162437732077`*^9}],

Cell[BoxData["8.31447`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9, 
   3.570816010984893*^9, 3.5708160954487247`*^9, 3.5708162437772083`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "7"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}, 
   3.570539142100366*^9, {3.570554838147128*^9, 3.5705548545010643`*^9}, 
   3.5705548849028025`*^9, {3.570796901071869*^9, 3.5707969015338955`*^9}, {
   3.5708073179186783`*^9, 3.570807321903906*^9}, 3.5708148419040256`*^9, 
   3.5708160263047695`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8lV8YAHDJ3iuREblWRjZXxmOTca+Zi5SQRLJF9t6kpSXSrzJKyUp4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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 995.1586351228798}, {-104.56687430309113`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5705572359982777`*^9, 3.570557271602314*^9, 3.5705579551504107`*^9, {
   3.5705580943653736`*^9, 3.5705581333856053`*^9}, {3.570796892456376*^9, 
   3.570796904154045*^9}, 3.570807208943445*^9, 3.5708072813775883`*^9, {
   3.5708073243270445`*^9, 3.57080734959549*^9}, 3.570807450351253*^9, {
   3.5708148246330376`*^9, 3.570814843993145*^9}, {3.5708160167252216`*^9, 
   3.570816030798026*^9}, 3.5708160958167453`*^9, 3.5708162441352286`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5705572046414843`*^9, 3.5705572046984873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "Zf", "]"}], ",", 
     RowBox[{"Im", "[", "Zf", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "7"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570554936758769*^9, 3.57055496859659*^9}, {
   3.5707969178858304`*^9, 3.5707969214870367`*^9}, 3.5708149014894333`*^9, {
   3.5708160359843235`*^9, 3.5708160365913577`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VF0YAHCiZF+yZklC0aaihPSGylT2ZeaOErKF7CLrMA1mLKWkvpRd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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 985.1586355349397}, {-104.56687238388452`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236051281*^9, 3.570557271666318*^9, 3.570557955226415*^9, {
   3.5705580944143763`*^9, 3.5705581334366083`*^9}, 3.570796923273138*^9, {
   3.5708073385868607`*^9, 3.5708073496454926`*^9}, 3.5708074504012556`*^9, 
   3.5708148247140427`*^9, 3.570814903420544*^9, 3.5708160390234966`*^9, 
   3.5708160959967556`*^9, 3.5708162443052387`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.570557207026621*^9, 3.5705572070806236`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox[
           RowBox[{"42.10365382785329`", " ", 
            RowBox[{"BesselK", "[", 
             RowBox[{"0", ",", 
              RowBox[{"0.01`", " ", 
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", 
                 SuperscriptBox["10", 
                  RowBox[{"5", "+", "lom"}]]}]]}]}], "]"}]}], 
           RowBox[{
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]], " ", 
            RowBox[{"BesselK", "[", 
             RowBox[{"1", ",", 
              RowBox[{"0.01`", " ", 
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", 
                 SuperscriptBox["10", 
                  RowBox[{"5", "+", "lom"}]]}]]}]}], "]"}]}]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox[
            RowBox[{"42.10365382785329`", " ", 
             RowBox[{"BesselK", "[", 
              RowBox[{"0", ",", 
               RowBox[{"0.01`", " ", 
                SqrtBox[
                 RowBox[{"\[ImaginaryI]", " ", 
                  SuperscriptBox["10", 
                   RowBox[{"5", "+", "lom"}]]}]]}]}], "]"}]}], 
            RowBox[{
             SqrtBox[
              RowBox[{"\[ImaginaryI]", " ", 
               SuperscriptBox["10", "lom"]}]], " ", 
             RowBox[{"BesselK", "[", 
              RowBox[{"1", ",", 
               RowBox[{"0.01`", " ", 
                SqrtBox[
                 RowBox[{"\[ImaginaryI]", " ", 
                  SuperscriptBox["10", 
                   RowBox[{"5", "+", "lom"}]]}]]}]}], "]"}]}]]}]]}]], 
       "]"}]}]], "]"}]}], "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.5705341416623573`*^9, 3.5705342311404753`*^9, 3.570535231352684*^9, 
   3.570539161852496*^9, 3.570539343825904*^9, 3.57055489307027*^9, 
   3.570555127712691*^9, 3.5705553209927454`*^9, 3.5705555658767524`*^9, 
   3.570557199095167*^9, 3.5705572360782824`*^9, 3.5705572716983194`*^9, 
   3.570557955257417*^9, {3.570558094444378*^9, 3.57055813346661*^9}, 
   3.5707969350128098`*^9, 3.5708073496724944`*^9, 3.5708074504282575`*^9, 
   3.5708148247580447`*^9, 3.5708160442057934`*^9, 3.570816096156765*^9, 
   3.5708162444102445`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "8"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}, 3.570555008228857*^9, 
   3.5707969433742886`*^9, 3.5708149232166767`*^9, {3.570816187360981*^9, 
   3.5708162000967097`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlmnk81N/3x23ZyT4z9j2KLDOJxPvaRgqhfRGRFpGK8ClriyUUaUGSFIWs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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-8., 6.}, {-45.788013439872614`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236110284*^9, 3.570557271809326*^9, 3.5705579553724236`*^9, {
   3.570558094558385*^9, 3.570558133580617*^9}, 3.570796945274397*^9, 
   3.5708073498115025`*^9, 3.5708074505602646`*^9, 3.570814824904053*^9, 
   3.5708149253728*^9, 3.570816047796999*^9, 3.5708160968638053`*^9, {
   3.5708161898951263`*^9, 3.5708162024538445`*^9}, 3.5708162450852833`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "lZM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "8"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5707969728999767`*^9, 3.570797001887635*^9}, 
   3.570816208353182*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN8fB/Cx74yZMUNlS9GCJEuyfD4SUiiUSIVEkURJkpBWvpJStpJS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     "]]}},
  Axes->True,
  AxesOrigin->{0, 1.},
  Method->{},
  PlotRange->{{-8., 6.}, {1.0000075987108825`, 3.0619030945812433`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5707970045507874`*^9, 3.5708073499755116`*^9, 
  3.5708074507132735`*^9, 3.5708148250600624`*^9, 3.5708149435658407`*^9, 
  3.5708160565554996`*^9, 3.5708160973588333`*^9, 3.570816210926329*^9, 
  3.5708162456763167`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}, 3.5705394635877542`*^9, {3.57053949726768*^9, 
   3.57053949778371*^9}, {3.570539586787801*^9, 3.570539603699768*^9}, 
   3.5705397446258287`*^9, 3.5707970178545485`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<cyl-Mat.txt\>\"", ",", "res", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}, {3.570539502739993*^9, 
   3.570539506052183*^9}, 3.57053956107633*^9, {3.570539655171712*^9, 
   3.570539663507189*^9}, 3.5705397519122453`*^9, {3.570555063732031*^9, 
   3.5705550730595646`*^9}, {3.5707970342074833`*^9, 3.570797034910524*^9}, {
   3.570807404896653*^9, 3.5708074258878536`*^9}, {3.5708148128803654`*^9, 
   3.5708148150724907`*^9}, {3.570816077424693*^9, 3.570816078542757*^9}}],

Cell[BoxData["\<\"cyl-Mat.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9, 
   3.570539344568947*^9, 3.570539511388488*^9, 3.570539566442637*^9, 
   3.57053967402779*^9, 3.570539755160431*^9, 3.570539785664176*^9, 
   3.5705550796219397`*^9, 3.5705551278827004`*^9, 3.5705553211777563`*^9, 
   3.5705555661347675`*^9, 3.5705571992251744`*^9, 3.5705572361762877`*^9, 
   3.5705572718723297`*^9, 3.5705579554434276`*^9, {3.570558094625388*^9, 
   3.5705581336466208`*^9}, 3.570797038781745*^9, 3.57080735082156*^9, {
   3.5708074135581484`*^9, 3.5708074508432813`*^9}, 3.570814825118066*^9, 
   3.5708149517153063`*^9, {3.570816090287429*^9, 3.5708160975688457`*^9}, 
   3.57081624590933*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.5708074561225834`*^9}],

Cell[BoxData["\[AliasDelimiter]"], "Output",
 CellChangeTimes->{3.5708148251500673`*^9, 3.5708160976198483`*^9, 
  3.570816246093341*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.5708161016450787`*^9}],

Cell[BoxData["\[AliasDelimiter]"], "Output",
 CellChangeTimes->{3.5708162462113476`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{-20, Automatic}, {Automatic, 4}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 892, 17, 186, "Title"],
Cell[CellGroupData[{
Cell[1484, 43, 589, 10, 164, "Input"],
Cell[2076, 55, 2239, 32, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4352, 92, 1896, 30, 54, "Input"],
Cell[6251, 124, 712, 14, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7000, 143, 757, 16, 47, "Input"],
Cell[7760, 161, 467, 13, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8264, 179, 178, 5, 47, "Input"],
Cell[8445, 186, 222, 6, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8704, 197, 146, 3, 47, "Input"],
Cell[8853, 202, 1148, 29, 106, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10038, 236, 308, 9, 47, "Input"],
Cell[10349, 247, 1107, 30, 151, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11493, 282, 147, 3, 47, "Input"],
Cell[11643, 287, 1422, 36, 151, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13102, 328, 147, 3, 47, "Input"],
Cell[13252, 333, 1424, 36, 151, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14713, 374, 365, 9, 77, "Input"],
Cell[15081, 385, 2579, 68, 159, "Output"],
Cell[17663, 455, 2782, 71, 217, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20482, 531, 152, 3, 47, "Input"],
Cell[20637, 536, 511, 8, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21185, 549, 1232, 26, 280, "Input"],
Cell[22420, 577, 610, 8, 47, "Output"],
Cell[23033, 587, 612, 8, 47, "Output"],
Cell[23648, 597, 633, 9, 66, "Output"],
Cell[24284, 608, 634, 9, 66, "Output"],
Cell[24921, 619, 634, 9, 66, "Output"],
Cell[25558, 630, 615, 8, 47, "Output"],
Cell[26176, 640, 613, 8, 47, "Output"],
Cell[26792, 650, 617, 8, 47, "Output"],
Cell[27412, 660, 618, 8, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28067, 673, 1497, 25, 47, "Input"],
Cell[29567, 700, 15584, 261, 96, "Output"]
}, Open  ]],
Cell[45166, 964, 96, 1, 47, "Input"],
Cell[CellGroupData[{
Cell[45287, 969, 484, 12, 47, "Input"],
Cell[45774, 983, 7624, 131, 96, "Output"]
}, Open  ]],
Cell[53413, 1117, 94, 1, 47, "Input"],
Cell[CellGroupData[{
Cell[53532, 1122, 395, 8, 47, "Input"],
Cell[53930, 1132, 3034, 79, 228, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57001, 1216, 1012, 18, 47, "Input"],
Cell[58016, 1236, 12710, 215, 715, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70763, 1456, 319, 9, 47, "Input"],
Cell[71085, 1467, 9038, 154, 137, "Output"]
}, Open  ]],
Cell[80138, 1624, 1163, 22, 47, "Input"],
Cell[CellGroupData[{
Cell[81326, 1650, 745, 12, 47, "Input"],
Cell[82074, 1664, 1769, 25, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83880, 1694, 87, 1, 47, "Input"],
Cell[83970, 1697, 137, 2, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84144, 1704, 87, 1, 47, "Input"],
Cell[84234, 1707, 88, 1, 47, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
